#!/usr/bin/env python
# -*- coding: utf-8 -*- 
#
# Program jest wolnym oprogramowaniem: możesz go rozprowadzać dalej i / lub modyfikować
# je na warunkach licencji GNU General Public License, wydanej przez
# Free Software Foundation; według wersji 3 tej Licencji lub
# (Do wyboru) którejś z późniejszych wersji.
#
# Program jest rozpowszechniany w nadziei, że będzie użyteczny,
#, Ale BEZ JAKIEJKOLWIEK GWARANCJI; nawet bez gwarancji
# Handlowej lub przydatności do KONKRETNEGO CELU. Zobacz
# Licencja Publiczna GNU więcej szczegółów.
#
# GNU General Public License, patrz <http://www.gnu.org/licenses/>.

from gimpfu import *  # Importujemy niezbędne moduły (odpowiednie biblioteki), 
          # wtyczka musi wiedział, z których wbudowanych funkcji ma korzystać.

def python_fu_template(image, drawable, color):

    gimp.context_push()  # Zapisujemy aktualny kolor pierwszoplanowy, 
	# aby móc z niego skorzystać potem:

    image.undo_group_start()  # funkcja służy do rozpoczęcia cofania grupy, 
	                          # stosowany w połączeniu z nazwą 'image.undo_group_end()'.
							  # Zakazujemy zapisu informacji dla umżliwienia cofnięć,
  # aby wszystkie operacje wykonane wtyczką można było anulować jednym klikiem
  # klikając Ctrl + Z lub wybierając w menu "Edycja" punkt "Cofnij"

    (x0, y0) = drawable.offsets  # przesunięcie, wyrównanie drawable, 
	# Użyjemy zamiast nieaktualnego: 'gimp-image-select-rectangle'.
    pdb.gimp_rect_select(image,
                         x0 + drawable.width  / 4,  # x coordinate of upper-left corner of rectangle
                         y0 + drawable.height / 4,  # y coordinate of upper-left corner of rectangle
                         drawable.width  / 2,       # The width of the rectangle (width >= 0)
                         drawable.height / 2,       # The height of the rectangle (height >= 0)
                         CHANNEL_OP_REPLACE, 0, 0)  # Operation The selection operation
						                            # Feather option for selections (TRUE or FALSE)
						                            # Radius for feather operation (feather-radius >=

    gimp.set_foreground(color)  #  Ustawiamy kolor na ten, który przekazujemy do funkcji
    pdb.gimp_edit_fill(drawable, FOREGROUND_FILL)  # zaznaczenie prostokąta wypełniamy kolorem

    image.undo_group_end()  # funkcja służy do zakończenia cofania grupy

    gimp.displays_flush()  # Aktualizujemy, odświeżamy obraz na wyświetlaczu
	
    gimp.context_pop()  # Przywracamy "stary" kolor pierwszego planu

register(
    "Szablon",  # Nazwa rejestrowanej wtyczki w Przeglądarce procedur, jeśli tak wpiszemy, oraz nazwa na krawędzi okna GUI 
		# GIMP doda prefiks "python-fu (lepiej prefiksu samemu nie dodawać).
    "Szablon wtyczki Python-Fu,\n tworzy określony prostokąt\n wypełniony wybranym kolorem ", # Opis okna wtyczki,
    "Szablon wtyczki, tworzy kolorowy prostokąt na istniejącym obrazie",  # Nazwa Dokumentacyjna, szerszy opis, pojawi się w PDB - Dodatkowe informacje.
    "Zbigniew Malach, Zbyma72age",  # Autor
    "Zbigniew Malach GPL",  # Informacja o prawach Autorskich
    "2015-05-30",  # data utworzenia wtyczki
    "Szablon Python-Fu...",  # Etykieta
    "RGB* GRAY*",  # Typ obrazu: z którym wtyczka może współpracować, przy tym oznaczeniu Nasza wtyczka obsługuje wszystkie 
		 # typy obrazów (ale przy tym oznaczeniu, bez obrazu Etykieta będzie wyszarzona), alternatywnie można "*".
    [
        (PF_IMAGE,    "image",    "Input Image",     0),
        (PF_DRAWABLE, "drawable", "Input Drawable",  0),
        (PF_COLOR,    "color",    "Kolor prostokąta", "orange")
    ],
    [],
    python_fu_template,
    menu="<Image>/TEST/Testowanie/") # Nazwa podana w def wywoływana Naszym kodem.  
	# Ścieżka do punktu menu GIMP-a, gdzie powinna się znajdować Etykieta wtyczki, 
	# używamy wielokropka ... w etykiecie otwierającej okno dialogowe wtyczki, 
	# (ścieżka do menu może startować z np. <Image> lub <Toolbox> czy <Layers>, wszędzie 
	# gdzie czujemy jej miejsce)  

main()  # funkcji main (), może być pusta